require( "HiddenObject/script/style.lua" );

gCurScreen = 0;
yGap = 30;
xGap = 60;

LeftGraphics = {
	"HiddenObject/UI/Button/leftnormal.png",
	"HiddenObject/UI/Button/leftdown.png",
	"HiddenObject/UI/Button/leftover.png",
};	

LeftCurveStyle= {
	type = kPush,
	flags = kHAlignCenter + kVAlignCenter,
	font = StandardButtonFont,
	graphics = LeftGraphics,
	sound = kDefaultButtonSound,
	rolloversound = kDefaultButtonOverSound,
};

RightGraphics = {
	"HiddenObject/UI/Button/rightnormal.png",
	"HiddenObject/UI/Button/rightdown.png",
	"HiddenObject/UI/Button/rightover.png",
};	

RightCurveStyle= {
	type = kPush,
	flags = kHAlignCenter + kVAlignCenter,
	font = StandardButtonFont,
	graphics = RightGraphics,
	sound = kDefaultButtonSound,
	rolloversound = kDefaultButtonOverSound,
};

HelpDialogBodyFont3 = {
  standardFont,
  18,
  Color(173,193,161,255)
};

HelpDialogBodyText3 = {
	parent=DefaultStyle,
	font = HelpDialogBodyFont3,
	flags = kVAlignCenter + kHAlignCenter,
	w=kMax,h=40
};
function SetScreen( screen )

	if screen == 1 then
		EnableWindow("helptext1",true)
		EnableWindow("helptext2",false)
		EnableWindow("helptext3",false)
	elseif screen ==2 then
		EnableWindow("helptext1",false)
		EnableWindow("helptext2",true)
		EnableWindow("helptext3",false)
	elseif screen == 3 then
		EnableWindow("helptext1",false)
		EnableWindow("helptext2",false)
		EnableWindow("helptext3",true)
		
	end

	gCurScreen = screen ;
end

HeaderFont = {
  "HiddenObject/UI/Font/OptimusPrincepsSemiBold.mvec",
  30,
  WhiteColor
};

TextStyle=
{
	parent=HelpDialogBodyText3,
	w=320,h=kMax-80
};
function GetWindowX()
	
	x = kCenter;
	if IsMainMenu() then x = 310; end
	return x;
end

function GetWindowY()
	
	y = kCenter - 45;
	if IsMainMenu() then y = 115; end
	return y;
end
MakeDialog
{
	-- Name the modal dialog
	name="help",
	Bitmap
	{
		image="HiddenObject/UI/HelpWindow/background",
		x=GetWindowX(),
		y=GetWindowY(),

		Window
		{
			name="helptext1",
			w=kMax,h=kMax,

			SetStyle(HelpDialogBodyText3),
			Text
			{
				x = kHAlignCenter;
				y = 10;
				name = "title",
				label= "simon",
				font = StandardHeaderFont, h = 40,
			};
		
			SetStyle(TextStyle),
			Text
			{
				label="simonhelp1",
				flags = kHAlignCenter ,
				x = 50,
				y = 70,
			},

			SetStyle(LeftCurveStyle),
			Button
			{
				label="close",
				name="close",
				align=kHAlignLeft+kVAlignBottom,
				x=xGap,y=kMax-yGap,
				command=function() CloseWindow(); end;
			},
			SetStyle(RightCurveStyle),
			Button
			{
				label="next",
				name="next",
				align=kHAlignRight+kVAlignBottom,
				x=kMax-xGap,y=kMax-yGap,
				command=function() SetScreen( gCurScreen+1 ); end;
			}
		},
		Window
		{
			name="helptext2",
			w=kMax,h=kMax,

			SetStyle(HelpDialogBodyText3),
			Text
			{
				x = kHAlignCenter;
				y = 10;
				name = "title",
				label= "simon",
				font = StandardHeaderFont, h = 40,
			};
			
			SetStyle(TextStyle),
			Text
			{
				label="simonhelp2",
				flags = kHAlignCenter ,
				x = 50,
				y = 70,
			},
			SetStyle(LeftCurveStyle),
			Button
			{
				label="back",
				name="back",
				align=kHAlignLeft+kVAlignBottom,
				x=xGap,y=kMax-yGap,
				command=function() SetScreen( gCurScreen-1 ); end;
			},
			SetStyle(RightCurveStyle),
			Button
			{
				label="next",
				name="next",
				align=kHAlignRight+kVAlignBottom,
				x=kMax-xGap,y=kMax-yGap,
				command=function() SetScreen( gCurScreen+1 ); end;
			},
		},				
		Window
		{
			name="helptext3",
			w=kMax,h=kMax,

			SetStyle(HelpDialogBodyText3),
			Text
			{
				x = kHAlignCenter;
				y = 10;
				name = "title",
				label= "simon",
				font = StandardHeaderFont, h = 40,
			};
			
			SetStyle(TextStyle),
			Text
			{
				label="simonhelp3",
				flags = kHAlignCenter ,
				x = 50,
				y = 70,
			},
			SetStyle(LeftCurveStyle),
			Button
			{
				label="back",
				name="back",
				align=kHAlignLeft+kVAlignBottom,
				x=xGap,y=kMax-yGap,
				command=function() SetScreen( gCurScreen-1 ); end;
			},
			SetStyle(RightCurveStyle),
			Button
			{
				label="close",
				name="close",
				align=kHAlignRight+kVAlignBottom,
				x=kMax-xGap,y=kMax-yGap,
				command=function() CloseWindow(); end;
			},
		}
	}
}

SetScreen(1);
